package ru.yandex.solomon.staffOnly.manager.ok;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public interface OkProvider {

    class Status {
        public final String key;
        public final String message;
        public final boolean ok;

        public Status(String key, boolean ok, String message) {
            this.key = key;
            this.message = message;
            this.ok = ok;
        }

        @Override
        public String toString() {
            return String.join(" ", key, Boolean.toString(ok), message);
        }
    }

    default String getCheckName() {
        return this.getClass().getSimpleName();
    }

    @Nonnull
    Status[] statuses();
}
