package ru.yandex.solomon.staffOnly.manager.ok;

import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Vladimir Gordiychuk
 */
@Component
public class OkProviderMetrics implements MetricSupplier {

    private final OkProvider[] oks;

    @Autowired
    public OkProviderMetrics(Optional<OkProvider[]> oks) {
        this.oks = oks.orElseGet(() -> new OkProvider[0]);
    }

    @Override
    public int estimateCount() {
        return oks.length;
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer c) {
        boolean allOk = true;
        for (OkProvider provider : oks) {
            boolean ok = isOk(provider);
            allOk &= ok;

            c.onMetricBegin(MetricType.IGAUGE);
            c.onLabelsBegin(commonLabels.size() + 2);
            commonLabels.forEach(c::onLabel);
            c.onLabel("sensor", "health");
            c.onLabel("check", provider.getCheckName());
            c.onLabelsEnd();
            c.onLong(tsMillis, ok ? 1L : 0L);
            c.onMetricEnd();
        }

        c.onMetricBegin(MetricType.IGAUGE);
        c.onLabelsBegin(commonLabels.size() + 2);
        commonLabels.forEach(c::onLabel);
        c.onLabel("sensor", "health");
        c.onLabelsEnd();
        c.onLong(tsMillis, allOk ? 1L : 0L);
        c.onMetricEnd();
    }

    private boolean isOk(OkProvider provider) {
        for (OkProvider.Status status : provider.statuses()) {
            if (!status.ok) {
                return false;
            }
        }

        return true;
    }
}
