package ru.yandex.solomon.staffOnly.manager.path;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.solomon.staffOnly.manager.find.NamedObjectFindContext;
import ru.yandex.solomon.staffOnly.manager.find.NamedObjectId;

/**
 * @author Stepan Koltsov
 */
public class ManagerObjectPath {
    @Nonnull
    private final NamedObjectId rootId;
    @Nonnull
    private final RelativePath fieldPath;

    public ManagerObjectPath(@Nonnull NamedObjectId rootId, @Nonnull List<PathElement> fieldPath) {
        this.rootId = rootId;
        this.fieldPath = new RelativePath(fieldPath);
    }

    @Nonnull
    public NamedObjectId getRootId() {
        return rootId;
    }

    @Nonnull
    public List<PathElement> getFieldPath() {
        return fieldPath.getPath();
    }

    public String getFieldPathJoined() {
        return fieldPath.getPath().stream()
                .map(PathElement::toString)
                .collect(Collectors.joining("."));
    }

    @Nonnull
    public ManagerObjectPath child(@Nonnull PathElement field) {
        List<PathElement> newPath = new ArrayList<>(fieldPath.getPath());
        newPath.add(field);
        return new ManagerObjectPath(rootId, newPath);
    }

    public ManagerObjectPath childField(String field) {
        return child(PathElement.field(field));
    }

    public ManagerObjectPath childIndex(int index) {
        return child(PathElement.index(index));
    }

    public static ManagerObjectPath parseBean(String classId, @Nonnull String beanParam, @Nonnull String fieldParam) {
        List<PathElement> fieldPath = Arrays.stream(StringUtils.split(fieldParam, '.'))
            .map(PathElement::parse)
            .collect(Collectors.toList());
        if (classId.isEmpty()) {
            classId = NamedObjectFindContext.BEAN_CLASS_ID;
        }
        return new ManagerObjectPath(new NamedObjectId(classId, beanParam), fieldPath);
    }

    @Override
    public String toString() {
        if (fieldPath.isEmpty()) {
            return rootId.toString();
        } else {
            return rootId + "." + getFieldPathJoined();
        }
    }
}
