package ru.yandex.solomon.staffOnly.manager.table;

import java.util.Comparator;
import java.util.function.Function;

/**
 * @author Vladimir Gordiychuk
 */
public class Column<R extends TableRecord> {
    public final String title;
    public final Function<R, ?> content;
    public final Comparator<R> comparator;

    public Column(String title, Function<R, ?> content, Comparator<R> comparator) {
        this.title = title;
        this.content = content;
        this.comparator = comparator;
    }

    public static <R extends TableRecord, T extends Comparable<T>> Column of(String title, Function<R, T> content) {
        return new Column<>(title, content, Comparator.comparing(content));
    }

    public static <R extends TableRecord> Column<R> of(String title, Function<R, Object> content, Comparator<R> comparator) {
        return new Column<>(title, content, comparator);
    }

    SortableTableColumnDefImpl<R> makeTableColumn(int index) {
        return new SortableTableColumnDefImpl<>(index, title, comparator, content);
    }
}
