package ru.yandex.solomon.staffOnly.manager.table;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
* @author Stepan Koltsov
*/
public class HtmlWriterTableDef<T> {
    public final List<TableColumnDef<T>> columns;

    public List<TableColumnDef<T>> getColumns() {
        return columns;
    }

    public HtmlWriterTableDef(List<TableColumnDef<T>> columns) {
        this.columns = columns;
    }

    @SafeVarargs
    public HtmlWriterTableDef(TableColumnDef<T>... columns) {
        this(Arrays.asList(columns));
    }

    @SafeVarargs
    public HtmlWriterTableDef(Class<T> clazz, TableColumnDef<T>... columns) {
        this(Stream.concat(HtmlWriterReflectColumnDef.tableColumns(clazz).stream(), Stream.of(columns))
                .collect(Collectors.toList()));
    }

}
