package ru.yandex.solomon.staffOnly.manager.table;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.solomon.staffOnly.html.HtmlWriter;
import ru.yandex.solomon.staffOnly.manager.ManagerWriter;
import ru.yandex.solomon.staffOnly.manager.ManagerWriterContext;
import ru.yandex.solomon.staffOnly.manager.WithAttrs;
import ru.yandex.solomon.staffOnly.www.ManagerPageTemplate;

/**
 * @author Vladimir Gordiychuk
 */
public class Table<R extends TableRecord> extends ManagerPageTemplate {
    private final ManagerWriterContext context;
    private final List<Column<R>> columns;
    private final List<R> records;
    private final Column<R> sortColumn;
    private final int sortBy;

    public Table(String title, ManagerWriterContext context, List<Column<R>> columns, List<R> records, int sortBy) {
        this(title, context, columns, records, sortBy, 0);
    }

    public Table(String title, ManagerWriterContext context, List<Column<R>> columns, List<R> records, int sortBy, int limit) {
        super(title);
        this.context = context;
        this.columns = columns;
        this.sortBy = sortBy;
        this.sortColumn = columns.get(Math.abs(sortBy) - 1);
        if (sortBy < 0) {
            records.sort(sortColumn.comparator.reversed());
        } else {
            records.sort(sortColumn.comparator);
        }

        if (limit == 0 || records.size() < limit) {
            this.records = records;
        } else {
            this.records = records.subList(0, limit);
        }
    }

    @Override
    protected void headExtra() {
        super.headExtra();
//                tag("meta", new Attr("http-equiv", "refresh"), new Attr("content", "5"));
    }

    @Override
    public void commonCssJs() {
        super.commonCssJs();
        tag("style", () -> {
            writeRaw(".table-hover tbody tr:hover > td { background-color: #9dddf2 }");
        });
    }

    @Override
    protected void content() {
        ManagerWriter writer = new ManagerWriter(context, this);
        List<TableColumnDef<R>> content = new ArrayList<>(columns.size());
        for (int index = 0; index < columns.size(); index++) {
            int columnIndex = index + 1;
            Column<R> column = columns.get(index);
            if (column == sortColumn && sortBy > 0) {
                columnIndex *= -1;
            }

            content.add(column.makeTableColumn(columnIndex));
        }

        tag("table", () -> {
            tr(() -> {
                for (TableColumnDef<R> column : content) {
                    column.writeTitleTh(writer);
                }
            });
            for (R row : records) {
                HtmlWriter.Attr[] attrs = (row instanceof WithAttrs)
                    ? ((WithAttrs) row).attrs()
                    : HtmlWriter.EMPTY_ATTRS;

                tr(() -> {
                    for (TableColumnDef<R> column : content) {
                        column.writeValueTd(row, writer);
                    }
                }, attrs);
            }
        }, Attr.cssClass("table simple-table2 table-hover table-condensed"));
    }
}
