package ru.yandex.solomon.staffOnly.manager.table;

import ru.yandex.solomon.staffOnly.manager.ManagerWriter;
import ru.yandex.solomon.staffOnly.manager.WritableToHtml;

/**
 * @author Stepan Koltsov
 */
public interface TableColumnDef<T> {
    String title();

    void writeTitleTh(ManagerWriter writer);

    void writeValue(T row, ManagerWriter writer);

    void writeValueTd(T row, ManagerWriter writer);

    default WritableToHtml bind(T row) {
        return htmlWriter -> writeValue(row, htmlWriter);
    }
}
