package ru.yandex.solomon.staffOnly.manager.table;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

import ru.yandex.solomon.staffOnly.html.CssLine;
import ru.yandex.solomon.staffOnly.html.HtmlWriter;
import ru.yandex.solomon.staffOnly.manager.ManagerWriter;

/**
 * @author Stepan Koltsov
 */
public class TableColumnDefImpl<T> implements TableColumnDef<T> {
    private final String title;
    private final Function<T, Object> content;
    private final List<HtmlWriter.Attr> tdAttrs;
    private final BiConsumer<HtmlWriter, String> titleWriter;

    public enum PredefStyle {
        MONOSPACE(List.of(HtmlWriter.Attr.style(CssLine.fontFamilyMonospace()))),
        ;

        private final List<HtmlWriter.Attr> attrs;

        PredefStyle(List<HtmlWriter.Attr> attrs) {
            this.attrs = attrs;
        }
    }

    public TableColumnDefImpl(String title, Function<T, Object> content) {
        this(title, content, List.of());
    }

    public TableColumnDefImpl(String title, Function<T, Object> content, List<HtmlWriter.Attr> tdAttrs) {
        this(title, content, tdAttrs, HtmlWriter::thText);
    }

    public TableColumnDefImpl(String title, Function<T, Object> content, List<HtmlWriter.Attr> tdAttrs, BiConsumer<HtmlWriter, String> titleWriter) {
        this.title = title;
        this.content = content;
        this.tdAttrs = tdAttrs;
        this.titleWriter = titleWriter;
    }

    public TableColumnDefImpl(String title, Function<T, Object> content, PredefStyle style) {
        this(title, content, style.attrs);
    }

    @Override
    public String title() {
        return title;
    }

    @Override
    public void writeValueTd(T row, ManagerWriter writer) {
        writer.writeCellTdWithAttrs(content.apply(row), tdAttrs);
    }

    @Override
    public void writeValue(T row, ManagerWriter writer) {
        writer.writeCellValue(content.apply(row));
    }

    @Override
    public void writeTitleTh(ManagerWriter writer) {
        titleWriter.accept(writer.getHtmlWriter(), title());
    }
}
