package ru.yandex.solomon.staffOnly.www;

import ru.yandex.solomon.staffOnly.JavaProcess;
import ru.yandex.solomon.staffOnly.html.HtmlWriterWithCommonLibraries;
import ru.yandex.solomon.util.host.HostUtils;

/**
 * @author Stepan Koltsov
 */
public abstract class ManagerPageTemplate extends HtmlWriterWithCommonLibraries {
    protected final String title;
    private final boolean staffOnlyPage;

    public ManagerPageTemplate(String title) {
        super();
        this.title = title;
        this.staffOnlyPage = false;
    }

    public ManagerPageTemplate(String title, boolean staffOnlyPage) {
        super();
        this.title = title;
        this.staffOnlyPage = staffOnlyPage;
    }

    @Override
    public void run() {
        doctype();
        html(() -> {
            head(() -> {
                commonCssJs();
                title(title);
                headExtra();
            });
            body(() -> {
                tag("nav.navbar.navbar-default", () -> {
                    if (staffOnlyPage) {
                        divContainerFluid(this::staffOnlyHeader);
                    } else {
                        divContainer(this::serviceHeader);
                    }
                });
                if (staffOnlyPage) {
                    divContainerFluid(this::renderContent);
                } else {
                    divContainer(this::renderContent);
                }
            });
        });
    }

    private void serviceHeader() {
        tag("div.navbar-header", () -> {
            tag("a", () -> write(JavaProcess.MAIN_CLASS),
                new Attr("href", "/internal"),
                new Attr("class", "navbar-brand"));
        });
        tag("ul.nav.navbar-nav", () -> {
            li(() -> aHref("/staffOnly", "Staff only"));
            li(() -> aHref("/manager", "Beans"));
            if ("CoremonMain".equals(JavaProcess.MAIN_CLASS)) {
                li(() -> aHref("/balancer-old", "Balancer (OLD)"));
                li(() -> aHref("/balancer", "Balancer (NEW)"));
            } else if (!"GatewayMain".equals(JavaProcess.MAIN_CLASS)) {
                li(() -> aHref("/balancer", "Balancer"));
            }
            li(() -> aHref("/threads", "Threads"));
            li(() -> aHref("/version", "Version"));
        });

        tag("p.navbar-text.navbar-right", () -> write("Host: " + HostUtils.getShortName()));
    }

    private void staffOnlyHeader() {
        tag("div.navbar-header", () -> {
            tag("a", () -> write("Solomon / Staff only"),
                new Attr("href", "/staffOnly"),
                new Attr("class", "navbar-brand"));
        });
        tag("p.navbar-text.navbar-right", () -> write("Host: " + HostUtils.getShortName()));
    }

    protected void header() {
        tag("div.page-header", () -> {
            hn(2, () -> write(title), Attr.style("word-wrap: break-word"));
        }, Attr.style("margin-top: 0px"));
    }

    protected void renderContent() {
        header();
        content();
    }

    protected void headExtra() {
    }

    protected abstract void content();
}
