package ru.yandex.solomon.staffOnly.html;

import java.util.ArrayList;
import java.util.Arrays;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Stepan Koltsov
 */
public class TagNameAndAttrsTest {

    @Test
    public void parse() {
        Assert.assertEquals(new TagNameAndAttrs("div", new ArrayList<>()), TagNameAndAttrs.parse("div"));
        Assert.assertEquals(new TagNameAndAttrs("div",
                    Arrays.asList(HtmlWriter.Attr.id("app"), HtmlWriter.Attr.cssClass("container"))),
                TagNameAndAttrs.parse("div#app.container"));
        Assert.assertEquals(new TagNameAndAttrs("label", Arrays.asList(new HtmlWriter.Attr("for", "xxyy"))),
                TagNameAndAttrs.parse("label for=xxyy"));
    }

}
