package ru.yandex.solomon.staffOnly.manager;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Maksim Leonov (nohttp@)
 */
public class ManagerPageTemplateTest {
    @Test
    public void updateParameter() {
        Assert.assertEquals("http://localhost?a=20", ManagerPageTemplate.updateParameter("http://localhost", "a", 20));
        Assert.assertEquals("http://localhost?a=20", ManagerPageTemplate.updateParameter("http://localhost?a=2", "a", 20));
        Assert.assertEquals("http://localhost?a=20", ManagerPageTemplate.updateParameter("http://localhost?a=20", "a", 20));
        Assert.assertEquals("http://localhost?a=20", ManagerPageTemplate.updateParameter("http://localhost?a=200", "a", 20));

        Assert.assertEquals("http://localhost?c=x&a=20", ManagerPageTemplate.updateParameter("http://localhost?c=x", "a", 20));
        Assert.assertEquals("http://localhost?c=x&a=20", ManagerPageTemplate.updateParameter("http://localhost?c=x&a=2", "a", 20));
        Assert.assertEquals("http://localhost?a=20&c=x", ManagerPageTemplate.updateParameter("http://localhost?a=20&c=x", "a", 20));
        Assert.assertEquals("http://localhost?c=x&a=20&d=y", ManagerPageTemplate.updateParameter("http://localhost?c=x&a=200&d=y", "a", 20));

        Assert.assertEquals("/?c=x&a=20", ManagerPageTemplate.updateParameter("/?c=x&a=2", "a", 20));
    }
}
