package ru.yandex.solomon.staffOnly.manager;

import java.util.concurrent.TimeUnit;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.misc.dataSize.DataSizeUnit;
import ru.yandex.misc.reflection.TypeX;

/**
 * @author Sergey Polovko
 */
public class ParameterParserTest {

    @Test
    public void parseString() {
        Object value = ParameterParser.parse("some string", TypeX.wrap(String.class));
        Assert.assertEquals("some string", value);
    }

    @Test
    public void parseInt() {
        Assert.assertEquals(0, ParameterParser.parse(null, TypeX.wrap(int.class)));
        Assert.assertEquals(0, ParameterParser.parse("", TypeX.wrap(int.class)));
        Assert.assertEquals(1, ParameterParser.parse("1", TypeX.wrap(int.class)));
        Assert.assertEquals(-1, ParameterParser.parse("-1", TypeX.wrap(int.class)));
    }

    @Test
    public void parseEnum() {
        Assert.assertNull(ParameterParser.parse(null, TypeX.wrap(TimeUnit.class)));
        Assert.assertNull(ParameterParser.parse("", TypeX.wrap(TimeUnit.class)));
        Assert.assertEquals(TimeUnit.SECONDS, ParameterParser.parse("SECONDS", TypeX.wrap(TimeUnit.class)));
        Assert.assertEquals(TimeUnit.HOURS, ParameterParser.parse("HOURS", TypeX.wrap(TimeUnit.class)));
        Assert.assertEquals(DataSizeUnit.MEGABYTES, ParameterParser.parse("MEGABYTES", TypeX.wrap(DataSizeUnit.class)));
    }
}
