package ru.yandex.stockpile.client.benchmarks;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import io.netty.util.concurrent.DefaultThreadFactory;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

import ru.yandex.grpc.utils.DefaultClientOptions;
import ru.yandex.stockpile.client.StockpileClient;
import ru.yandex.stockpile.client.StockpileClientOptions;
import ru.yandex.stockpile.client.StockpileClients;
import ru.yandex.stockpile.client.util.InMemoryStockpileCluster;

/**
 * @author Vladimir Gordiychuk
 */
@State(Scope.Benchmark)
public class Cluster {
    @Param({"1", "16"})
    private int countNodes;

    private InMemoryStockpileCluster cluster;
    private StockpileClient client;
    private ExecutorService executorService;

    @Setup
    public void setUp() throws IOException {
        executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(),
                new DefaultThreadFactory("stockpile-client-grpc")
        );

        cluster = InMemoryStockpileCluster.newBuilder()
                .serverCount(countNodes)
                .shardRange(1, 4096)
                .build();

        var opts = StockpileClientOptions.newBuilder(
                DefaultClientOptions.newBuilder()
                    .setRpcExecutor(executorService)
                    .setRequestTimeOut(30, TimeUnit.SECONDS))
            .setExpireClusterMetadata(5, TimeUnit.SECONDS)
            .build();

        client = StockpileClients.create(cluster.getServerList(), opts);
    }

    @TearDown
    public void terminate() throws InterruptedException {
        client.close();
        cluster.stop();
        executorService.shutdownNow();
    }

    public StockpileClient getClient() {
        return client;
    }
}
