package ru.yandex.stockpile.client.benchmarks;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.stockpile.api.CreateMetricRequest;

/**
 * @author Vladimir Gordiychuk
 */
@Fork(value = 1)
@Measurement(iterations = 5, time = 5, timeUnit = TimeUnit.SECONDS)
@Warmup(iterations = 5, time = 5, timeUnit = TimeUnit.SECONDS)
@BenchmarkMode(Mode.Throughput)
@OutputTimeUnit(TimeUnit.SECONDS)
public class JmhClientCreateMetric {

    public static void main(String[] args) throws RunnerException, IOException {
        Options opt = new OptionsBuilder()
                .include(JmhClientCreateMetric.class.getName())
                .detectJvmArgs()
                .jvmArgsAppend("-Xmx3g", "-Xms3g")
                .build();

        new Runner(opt).run();
    }

    @Benchmark
    public Object createMetric(Cluster state) {
        CreateMetricRequest request = CreateMetricRequest.newBuilder()
                .setType(MetricType.DGAUGE)
                .build();

        return state.getClient().createMetric(request).join();
    }

}
