package ru.yandex.stockpile.client.benchmarks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

import ru.yandex.solomon.model.protobuf.MetricId;
import ru.yandex.stockpile.api.TReadRequest;
import ru.yandex.stockpile.client.StockpileClient;

/*

Benchmark                                (countNodes)  (countPoints)  (inflighRequests)  Mode  Cnt         Score         Error  Units
JmhClientReadBenchmark.singleThreadRead             1              0                  1  avgt    5    115870.587 ±   66661.677  ns/op
JmhClientReadBenchmark.singleThreadRead             1              0                  5  avgt    5    202949.646 ±   34507.529  ns/op
JmhClientReadBenchmark.singleThreadRead             1              0                 10  avgt    5    348041.129 ±   98120.622  ns/op
JmhClientReadBenchmark.singleThreadRead             1              0                100  avgt    5   2590964.633 ±  598345.165  ns/op
JmhClientReadBenchmark.singleThreadRead             1           1000                  1  avgt    5    224413.997 ±   96734.542  ns/op
JmhClientReadBenchmark.singleThreadRead             1           1000                  5  avgt    5    672410.434 ±  302011.789  ns/op
JmhClientReadBenchmark.singleThreadRead             1           1000                 10  avgt    5   1182956.634 ±  387800.025  ns/op
JmhClientReadBenchmark.singleThreadRead             1           1000                100  avgt    5  11179583.717 ± 4039767.395  ns/op
JmhClientReadBenchmark.singleThreadRead             1           5074                  1  avgt    5    640360.630 ±  129823.493  ns/op
JmhClientReadBenchmark.singleThreadRead             1           5074                  5  avgt    5   2185782.698 ±  631861.026  ns/op
JmhClientReadBenchmark.singleThreadRead             1           5074                 10  avgt    5   3954553.998 ± 1099998.861  ns/op
JmhClientReadBenchmark.singleThreadRead             1           5074                100  avgt    5  37509849.016 ± 3268482.138  ns/op
JmhClientReadBenchmark.singleThreadRead            16              0                  1  avgt    5    136508.735 ±   37043.415  ns/op
JmhClientReadBenchmark.singleThreadRead            16              0                  5  avgt    5    330353.250 ±  175821.790  ns/op
JmhClientReadBenchmark.singleThreadRead            16              0                 10  avgt    5    448763.107 ±   93309.884  ns/op
JmhClientReadBenchmark.singleThreadRead            16              0                100  avgt    5   2502322.394 ±  582991.376  ns/op
JmhClientReadBenchmark.singleThreadRead            16           1000                  1  avgt    5    221817.504 ±   35608.230  ns/op
JmhClientReadBenchmark.singleThreadRead            16           1000                  5  avgt    5    678848.021 ±  206618.788  ns/op
JmhClientReadBenchmark.singleThreadRead            16           1000                 10  avgt    5   1187319.062 ±  201385.996  ns/op
JmhClientReadBenchmark.singleThreadRead            16           1000                100  avgt    5   8435318.129 ± 2032391.186  ns/op
JmhClientReadBenchmark.singleThreadRead            16           5074                  1  avgt    5    682255.753 ±   49964.686  ns/op
JmhClientReadBenchmark.singleThreadRead            16           5074                  5  avgt    5   1981510.464 ±  519868.076  ns/op
JmhClientReadBenchmark.singleThreadRead            16           5074                 10  avgt    5   3710751.836 ± 1319006.892  ns/op
JmhClientReadBenchmark.singleThreadRead            16           5074                100  avgt    5  30382799.338 ± 6052794.526  ns/op

 */

/**
 * @author Vladimir Gordiychuk
 */
@State(Scope.Benchmark)
@Threads(1)
@Fork(value = 1)
@Measurement(iterations = 5, time = 5, timeUnit = TimeUnit.SECONDS)
@Warmup(iterations = 5, time = 5, timeUnit = TimeUnit.SECONDS)
@BenchmarkMode(Mode.AverageTime)
@OutputTimeUnit(TimeUnit.MILLISECONDS)
public class JmhClientReadBenchmark {

    @Param({"1", "10", "100"})
    private int inflighRequests;

    public static void main(String[] args) throws RunnerException, IOException {
        Options opt = new OptionsBuilder()
                .include(JmhClientReadBenchmark.class.getName())
                .detectJvmArgs()
                .jvmArgsAppend("-Xmx3g", "-Xms3g")
//                .param("countNodes", "1")
//                .param("inflighRequests", "100")
//                .param("countPoints", "5074")
                .build();

        new Runner(opt).run();
    }

    @Benchmark
    public Object readOne(ClusterWithData cluster) {
        List<TReadRequest> requests = new ArrayList<>(inflighRequests);
        for (int index = 0; index < inflighRequests; index++) {
            MetricId metricId = cluster.nextMetric();
            TReadRequest request = TReadRequest.newBuilder().setMetricId(metricId).build();
            requests.add(request);
        }

        StockpileClient client = cluster.getClient();
        CompletableFuture<?>[] futures = new CompletableFuture<?>[inflighRequests];
        for (int index = 0; index < inflighRequests; index++) {
            futures[index] = client.readOne(requests.get(index));
        }

        return CompletableFuture.allOf(futures).join();
    }
}
