package ru.yandex.stockpile.client.benchmarks;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

/*

Benchmark                                                      (countNodes)  Mode  Cnt  Score   Error  Units
JmhClientRefreshClusterStateBenchmark.forceUpdateClusterState             1  avgt    5  0.630 ± 0.122  ms/op
JmhClientRefreshClusterStateBenchmark.forceUpdateClusterState            16  avgt    5  1.133 ± 0.245  ms/op

 */

/**
 * @author Vladimir Gordiychuk
 */
@Fork(value = 1)
@Measurement(iterations = 5, time = 5, timeUnit = TimeUnit.SECONDS)
@Warmup(iterations = 5, time = 5, timeUnit = TimeUnit.SECONDS)
@BenchmarkMode(Mode.AverageTime)
@OutputTimeUnit(TimeUnit.MILLISECONDS)
public class JmhClientRefreshClusterStateBenchmark {

    @Benchmark
    @Threads(1)
    public Object forceUpdateClusterState(Cluster state) {
        return state.getClient().forceUpdateClusterMetaData().join();
    }

    public static void main(String[] args) throws RunnerException, IOException {
        Options opt = new OptionsBuilder()
                .include(JmhClientRefreshClusterStateBenchmark.class.getName())
                .detectJvmArgs()
                .jvmArgsAppend("-Xmx3g", "-Xms3g")
                .build();

        new Runner(opt).run();
    }
}
