package ru.yandex.stockpile.client;

import javax.annotation.ParametersAreNonnullByDefault;


/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class Attempt<ReqT, RespT> {
    private final int attemptNumber;
    private final ReqT request;
    private final RespT response;
    private final long deadline;

    public Attempt(int attemptNumber, ReqT request, RespT response, long deadline) {
        this.attemptNumber = attemptNumber;
        this.request = request;
        this.response = response;
        this.deadline = deadline;
    }

    public int getAttemptNumber() {
        return attemptNumber;
    }

    public ReqT getRequest() {
        return request;
    }

    public RespT getResponse() {
        return response;
    }

    public long getDeadline() {
        return deadline;
    }

    public Attempt<ReqT, RespT> next(RespT response) {
        return new Attempt<>(attemptNumber + 1, request, response, deadline);
    }

    @Override
    public String toString() {
        return "Attempt{" +
                "attemptNumber=" + attemptNumber +
                ", request=" + request +
                ", response=" + response +
                '}';
    }
}
