package ru.yandex.stockpile.client;

import java.util.EnumSet;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.stockpile.api.EColumnFlag;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class ColumnFlagMask {
    public static final int MINIMAL_DOUBLE_MASK = ColumnFlagMask.mask(EColumnFlag.COLUMN_TIMESTAMP, EColumnFlag.COLUMN_DOUBLE);
    public static final int MINIMAL_LONG_MASK = ColumnFlagMask.mask(EColumnFlag.COLUMN_TIMESTAMP, EColumnFlag.COLUMN_LONG_VALUE);
    public static final int MINIMAL_LOG_HISTOGRAM_MASK = ColumnFlagMask.mask(EColumnFlag.COLUMN_TIMESTAMP, EColumnFlag.COLUMN_LOG_HISTOGRAM);
    public static final int MINIMAL_HISTOGRAM = ColumnFlagMask.mask(EColumnFlag.COLUMN_TIMESTAMP, EColumnFlag.COLUMN_HISTOGRAM);
    public static final int MINIMAL_ISUMMARY = ColumnFlagMask.mask(EColumnFlag.COLUMN_TIMESTAMP, EColumnFlag.COLUMN_ISUMMARY);
    public static final int MINIMAL_DSUMMARY = ColumnFlagMask.mask(EColumnFlag.COLUMN_TIMESTAMP, EColumnFlag.COLUMN_DSUMMARY);

    public static int mask(EColumnFlag... flags) {
        int result = 0;
        for (EColumnFlag flag : flags) {
            result |= flag.getNumber();
        }
        return result;
    }

    public static Set<EColumnFlag> flags(int mask) {
        EnumSet<EColumnFlag> result = EnumSet.noneOf(EColumnFlag.class);
        for (EColumnFlag flag : EColumnFlag.values()) {
            if ((mask & flag.getNumber()) != 0) {
                result.add(flag);
            }
        }

        return result;
    }
}
