package ru.yandex.stockpile.client;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.net.HostAndPort;

import ru.yandex.stockpile.client.impl.GrpcStockpileClient;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public final class StockpileClients {

    private StockpileClients() {
    }

    public static StockpileClient create(List<HostAndPort> addresses, StockpileClientOptions options) {
        var addressStr = addresses.stream()
                .map(HostAndPort::toString)
                .collect(Collectors.toList());
        return createDynamic(addressStr, options);
    }

    public static StockpileClient createDynamic(List<String> addresses, StockpileClientOptions options) {
        return new GrpcStockpileClient(addresses, options);
    }
}
