package ru.yandex.stockpile.client;

/**
 * @author Vladimir Gordiychuk
 */
public final class StopStrategies {
    private static final StopStrategy NEVER_STOP = new ConstantStopStrategy(false);
    private static final StopStrategy ALWAYS_STOP = new ConstantStopStrategy(true);

    private StopStrategies() {
    }

    public static StopStrategy neverStop() {
        return NEVER_STOP;
    }

    public static StopStrategy alwaysStop() {
        return ALWAYS_STOP;
    }

    public static StopStrategy stopAfterAttempt(int attemptLimit) {
        return new StopAfterAttemptStrategy(attemptLimit);
    }

    private static final class ConstantStopStrategy implements StopStrategy {

        private final boolean stop;

        private ConstantStopStrategy(boolean stop) {
            this.stop = stop;
        }

        @Override
        public boolean shouldStop(Attempt attempt) {
            return stop;
        }
    }

    private static final class StopAfterAttemptStrategy implements StopStrategy {
        private final int attemptLimit;

        private StopAfterAttemptStrategy(int attemptLimit) {
            this.attemptLimit = attemptLimit;
        }

        @Override
        public boolean shouldStop(Attempt attempt) {
            return attempt.getAttemptNumber() <= attemptLimit;
        }
    }
}
