package ru.yandex.stockpile.client.impl;

import java.io.InputStream;

import io.grpc.MethodDescriptor;

import ru.yandex.stockpile.client.mem.AccumulatedShardCommand;

/**
 * @author Vladimir Gordiychuk
 */
public class AccumulatedShardCommandMarshaller implements MethodDescriptor.Marshaller<AccumulatedShardCommand> {
    private static final ByteBufMarshaller byteBufMarshaller = new ByteBufMarshaller();

    @Override
    public InputStream stream(AccumulatedShardCommand value) {
        return byteBufMarshaller.stream(value.getReadOnlyBuffer());
    }

    @Override
    public AccumulatedShardCommand parse(InputStream stream) {
        throw new UnsupportedOperationException("Unsupported backward marshalling");
    }
}
