package ru.yandex.stockpile.client.impl;

import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;

import ru.yandex.stockpile.api.CreateMetricRequest;
import ru.yandex.stockpile.api.CreateMetricResponse;
import ru.yandex.stockpile.api.DeleteMetricDataRequest;
import ru.yandex.stockpile.api.DeleteMetricDataResponse;
import ru.yandex.stockpile.api.DeleteMetricRequest;
import ru.yandex.stockpile.api.DeleteMetricResponse;
import ru.yandex.stockpile.api.ReadMetricsMetaRequest;
import ru.yandex.stockpile.api.ReadMetricsMetaResponse;
import ru.yandex.stockpile.api.StockpileServiceGrpc;
import ru.yandex.stockpile.api.TAllocateLocalIdsRequest;
import ru.yandex.stockpile.api.TAllocateLocalIdsResponse;
import ru.yandex.stockpile.api.TCompressedReadManyResponse;
import ru.yandex.stockpile.api.TCompressedReadResponse;
import ru.yandex.stockpile.api.TCompressedWriteRequest;
import ru.yandex.stockpile.api.TCompressedWriteResponse;
import ru.yandex.stockpile.api.TDeleteMetricByShardRequest;
import ru.yandex.stockpile.api.TDeleteMetricByShardResponse;
import ru.yandex.stockpile.api.TReadManyRequest;
import ru.yandex.stockpile.api.TReadRequest;
import ru.yandex.stockpile.api.TReadResponse;
import ru.yandex.stockpile.api.TServerStatusRequest;
import ru.yandex.stockpile.api.TServerStatusResponse;
import ru.yandex.stockpile.api.TShardCommandRequest;
import ru.yandex.stockpile.api.TShardCommandResponse;
import ru.yandex.stockpile.api.TUncompressedReadManyResponse;
import ru.yandex.stockpile.api.TWriteDataBinaryRequest;
import ru.yandex.stockpile.api.TWriteDataBinaryResponse;
import ru.yandex.stockpile.api.TWriteLogRequest;
import ru.yandex.stockpile.api.TWriteLogResponse;
import ru.yandex.stockpile.api.TWriteRequest;
import ru.yandex.stockpile.api.TWriteResponse;
import ru.yandex.stockpile.client.mem.AccumulatedShardCommand;

/**
 * @author Vladimir Gordiychuk
 */
final class EndpointDescriptors {
    static final EndpointDescriptor<TServerStatusRequest, TServerStatusResponse> METHOD_SERVER_STATUS =
            EndpointDescriptor.<TServerStatusRequest, TServerStatusResponse>newBuilder()
                    .setGrpcMethod(StockpileServiceGrpc.getServerStatusMethod())
                    .setShardIdResolver(req -> 0)
                    .setDeadlineResolver(TServerStatusRequest::getDeadline)
                    .setStatusCodeResolver(TServerStatusResponse::getStatus)
                    .setErrorHandling((code, s) -> TServerStatusResponse.newBuilder()
                            .setStatus(code)
                            .setStatusMessage(s)
                            .build())
                    .build();

    static final EndpointDescriptor<CreateMetricRequest, CreateMetricResponse> METHOD_CREATE_METRIC =
            EndpointDescriptor.<CreateMetricRequest, CreateMetricResponse>newBuilder()
                    .setGrpcMethod(StockpileServiceGrpc.getCreateMetricMethod())
                    .setShardIdResolver(req -> req.getMetricId().getShardId())
                    .setDeadlineResolver(CreateMetricRequest::getDeadline)
                    .setStatusCodeResolver(CreateMetricResponse::getStatus)
                    .setErrorHandling((code, s) -> CreateMetricResponse.newBuilder()
                            .setStatus(code)
                            .setStatusMessage(s)
                            .build())
                    .setReadyPredicate(Shard::isReady)
                    .build();

    static final EndpointDescriptor<DeleteMetricRequest, DeleteMetricResponse> METHOD_DELETE_METRIC =
            EndpointDescriptor.<DeleteMetricRequest, DeleteMetricResponse>newBuilder()
                    .setGrpcMethod(StockpileServiceGrpc.getDeleteMetricMethod())
                    .setShardIdResolver(req -> req.getMetricId().getShardId())
                    .setDeadlineResolver(DeleteMetricRequest::getDeadline)
                    .setStatusCodeResolver(DeleteMetricResponse::getStatus)
                    .setErrorHandling((code, s) -> DeleteMetricResponse.newBuilder()
                            .setStatus(code)
                            .setStatusMessage(s)
                            .build())
                    .setReadyPredicate(Shard::isReady)
                    .build();

    static final EndpointDescriptor<DeleteMetricDataRequest, DeleteMetricDataResponse> METHOD_DELETE_METRIC_DATA =
            EndpointDescriptor.<DeleteMetricDataRequest, DeleteMetricDataResponse>newBuilder()
                    .setGrpcMethod(StockpileServiceGrpc.getDeleteMetricDataMethod())
                    .setShardIdResolver(req -> req.getMetricId().getShardId())
                    .setDeadlineResolver(DeleteMetricDataRequest::getDeadline)
                    .setStatusCodeResolver(DeleteMetricDataResponse::getStatus)
                    .setErrorHandling((code, s) -> DeleteMetricDataResponse.newBuilder()
                            .setStatus(code)
                            .setStatusMessage(s)
                            .build())
                    .setReadyPredicate(Shard::isReady)
                    .build();

    static final EndpointDescriptor<TWriteRequest, TWriteResponse> METHOD_WRITE_ONE =
            EndpointDescriptor.<TWriteRequest, TWriteResponse>newBuilder()
                    .setGrpcMethod(StockpileServiceGrpc.getWriteOneMethod())
                    .setShardIdResolver(req -> req.getMetricId().getShardId())
                    .setDeadlineResolver(TWriteRequest::getDeadline)
                    .setStatusCodeResolver(TWriteResponse::getStatus)
                    .setErrorHandling((code, s) -> TWriteResponse.newBuilder()
                            .setStatus(code)
                            .setStatusMessage(s)
                            .build())
                    .setReadyPredicate(Shard::isReady)
                    .build();

    static final EndpointDescriptor<TCompressedWriteRequest, TCompressedWriteResponse> METHOD_WRITE_COMPRESSED_ONE =
            EndpointDescriptor.<TCompressedWriteRequest, TCompressedWriteResponse>newBuilder()
                    .setGrpcMethod(StockpileServiceGrpc.getWriteCompressedOneMethod())
                    .setShardIdResolver(req -> req.getMetricId().getShardId())
                    .setDeadlineResolver(TCompressedWriteRequest::getDeadline)
                    .setStatusCodeResolver(TCompressedWriteResponse::getStatus)
                    .setErrorHandling((code, s) -> TCompressedWriteResponse.newBuilder()
                            .setStatus(code)
                            .setStatusMessage(s)
                            .build())
                    .setReadyPredicate(Shard::isReady)
                    .build();

    static final EndpointDescriptor<TWriteDataBinaryRequest, TWriteDataBinaryResponse> METHOD_WRITE_DATA_BINARY =
        EndpointDescriptor.<TWriteDataBinaryRequest, TWriteDataBinaryResponse>newBuilder()
            .setGrpcMethod(StockpileServiceGrpc.getWriteDataBinaryMethod())
            .setShardIdResolver(TWriteDataBinaryRequest::getShardId)
            .setDeadlineResolver(TWriteDataBinaryRequest::getDeadline)
            .setStatusCodeResolver(TWriteDataBinaryResponse::getStatus)
            .setErrorHandling((code, s) -> TWriteDataBinaryResponse.newBuilder()
                .setStatus(code)
                .setStatusMessage(s)
                .build())
            .setReadyPredicate(Shard::isReady)
            .build();

    static final EndpointDescriptor<TWriteLogRequest, TWriteLogResponse> METHOD_WRITE_LOG =
        EndpointDescriptor.<TWriteLogRequest, TWriteLogResponse>newBuilder()
            .setGrpcMethod(StockpileServiceGrpc.getWriteLogMethod())
            .setShardIdResolver(TWriteLogRequest::getShardId)
            .setDeadlineResolver(TWriteLogRequest::getDeadline)
            .setStatusCodeResolver(TWriteLogResponse::getStatus)
            .setErrorHandling((code, s) -> TWriteLogResponse.newBuilder()
                .setStatus(code)
                .setStatusMessage(s)
                .build())
            .setReadyPredicate(Shard::isReady)
            .build();

    static final EndpointDescriptor<TReadRequest, TReadResponse> METHOD_READ_ONE =
            EndpointDescriptor.<TReadRequest, TReadResponse>newBuilder()
                    .setGrpcMethod(StockpileServiceGrpc.getReadOneMethod())
                    .setShardIdResolver(req -> req.getMetricId().getShardId())
                    .setDeadlineResolver(TReadRequest::getDeadline)
                    .setStatusCodeResolver(TReadResponse::getStatus)
                    .setErrorHandling((code, s) -> TReadResponse.newBuilder()
                            .setStatus(code)
                            .setStatusMessage(s)
                            .build())
                    .setReadyPredicate(Shard::isReady)
                    .build();

    static final EndpointDescriptor<TReadManyRequest, TUncompressedReadManyResponse> METHOD_READ_UNCOMPRESSED_MANY =
            EndpointDescriptor.<TReadManyRequest, TUncompressedReadManyResponse>newBuilder()
                    .setGrpcMethod(StockpileServiceGrpc.getReadUncompressedManyMethod())
                    .setShardIdResolver(TReadManyRequest::getShardId)
                    .setDeadlineResolver(TReadManyRequest::getDeadline)
                    .setStatusCodeResolver(TUncompressedReadManyResponse::getStatus)
                    .setErrorHandling((code, s) -> TUncompressedReadManyResponse.newBuilder()
                            .setStatus(code)
                            .setStatusMessage(s)
                            .build())
                    .setReadyPredicate(Shard::isReady)
                    .build();

    static final EndpointDescriptor<TReadRequest, TCompressedReadResponse> METHOD_READ_COMPRESSED_ONE =
            EndpointDescriptor.<TReadRequest, TCompressedReadResponse>newBuilder()
                    .setGrpcMethod(StockpileServiceGrpc.getReadCompressedOneMethod())
                    .setShardIdResolver(req -> req.getMetricId().getShardId())
                    .setDeadlineResolver(TReadRequest::getDeadline)
                    .setStatusCodeResolver(TCompressedReadResponse::getStatus)
                    .setErrorHandling((code, s) -> TCompressedReadResponse.newBuilder()
                            .setStatus(code)
                            .setStatusMessage(s)
                            .build())
                    .setReadyPredicate(Shard::isReady)
                    .build();

    static final EndpointDescriptor<TReadManyRequest, TCompressedReadManyResponse> METHOD_READ_COMPRESSED_MANY =
            EndpointDescriptor.<TReadManyRequest, TCompressedReadManyResponse>newBuilder()
                    .setGrpcMethod(StockpileServiceGrpc.getReadCompressedManyMethod())
                    .setShardIdResolver(TReadManyRequest::getShardId)
                    .setDeadlineResolver(TReadManyRequest::getDeadline)
                    .setStatusCodeResolver(TCompressedReadManyResponse::getStatus)
                    .setErrorHandling((code, s) -> TCompressedReadManyResponse.newBuilder()
                            .setStatus(code)
                            .setStatusMessage(s)
                            .build())
                    .setReadyPredicate(Shard::isReady)
                    .build();

    static final EndpointDescriptor<TShardCommandRequest, TShardCommandResponse> METHOD_BULK_SHARD_COMMAND =
            EndpointDescriptor.<TShardCommandRequest, TShardCommandResponse>newBuilder()
                    .setGrpcMethod(StockpileServiceGrpc.getBulkShardCommandMethod())
                    .setShardIdResolver(TShardCommandRequest::getShardId)
                    .setDeadlineResolver(TShardCommandRequest::getDeadline)
                    .setStatusCodeResolver(TShardCommandResponse::getStatus)
                    .setErrorHandling((code, s) -> TShardCommandResponse.newBuilder()
                            .setStatus(code)
                            .setStatusMessage(s)
                            .build())
                    .setReadyPredicate(Shard::isReady)
                    .build();

    static final EndpointDescriptor<AccumulatedShardCommand, TShardCommandResponse> METHOD_BULK_SHARD_COMMAND_ACCUMULATED =
            EndpointDescriptor.<AccumulatedShardCommand, TShardCommandResponse>newBuilder()
                    .setGrpcMethod(MethodDescriptor.<AccumulatedShardCommand, TShardCommandResponse>newBuilder()
                            .setType(MethodDescriptor.MethodType.UNARY)
                            .setFullMethodName(StockpileServiceGrpc.getBulkShardCommandMethod().getFullMethodName())
                            .setRequestMarshaller(new AccumulatedShardCommandMarshaller())
                            .setResponseMarshaller(ProtoUtils.marshaller(TShardCommandResponse.getDefaultInstance()))
                            .build())
                    .setShardIdResolver(AccumulatedShardCommand::getShardId)
                    .setDeadlineResolver(AccumulatedShardCommand::getDeadlineMillis)
                    .setStatusCodeResolver(TShardCommandResponse::getStatus)
                    .setErrorHandling((code, s) -> TShardCommandResponse.newBuilder()
                            .setStatus(code)
                            .setStatusMessage(s)
                            .build())
                    .setReadyPredicate(Shard::isReady)
                    .build();

    static final EndpointDescriptor<ReadMetricsMetaRequest, ReadMetricsMetaResponse> METHOD_READ_METRICS_META =
        EndpointDescriptor.<ReadMetricsMetaRequest, ReadMetricsMetaResponse>newBuilder()
            .setGrpcMethod(StockpileServiceGrpc.getReadMetricsMetaMethod())
            .setShardIdResolver(ReadMetricsMetaRequest::getShardId)
            .setDeadlineResolver(ReadMetricsMetaRequest::getDeadline)
            .setStatusCodeResolver(ReadMetricsMetaResponse::getStatus)
            .setErrorHandling((code, s) -> ReadMetricsMetaResponse.newBuilder()
                .setStatus(code)
                .setStatusMessage(s)
                .build())
            .setReadyPredicate(Shard::isReady)
            .build();

    static final EndpointDescriptor<TAllocateLocalIdsRequest, TAllocateLocalIdsResponse> METHOD_ALLOCATE_LOCAL_IDS =
        EndpointDescriptor.<TAllocateLocalIdsRequest, TAllocateLocalIdsResponse>newBuilder()
            .setGrpcMethod(StockpileServiceGrpc.getAllocateLocalIdsMethod())
            .setShardIdResolver(TAllocateLocalIdsRequest::getShardId)
            .setDeadlineResolver(TAllocateLocalIdsRequest::getDeadline)
            .setStatusCodeResolver(TAllocateLocalIdsResponse::getStatus)
            .setErrorHandling((code, s) -> TAllocateLocalIdsResponse.newBuilder()
                .setStatus(code)
                .setStatusMessage(s)
                .build())
            .setReadyPredicate(Shard::isReady)
            .build();

    static final EndpointDescriptor<TDeleteMetricByShardRequest, TDeleteMetricByShardResponse> METHOD_DELETE_METRIC_BY_SHARD =
            EndpointDescriptor.<TDeleteMetricByShardRequest, TDeleteMetricByShardResponse>newBuilder()
                    .setGrpcMethod(StockpileServiceGrpc.getDeleteMetricByShardMethod())
                    .setShardIdResolver(TDeleteMetricByShardRequest::getShardId)
                    .setDeadlineResolver(TDeleteMetricByShardRequest::getDeadline)
                    .setStatusCodeResolver(TDeleteMetricByShardResponse::getStatus)
                    .setErrorHandling((code, s) -> TDeleteMetricByShardResponse.newBuilder()
                            .setStatus(code)
                            .setStatusMessage(s)
                            .build())
                    .setReadyPredicate(Shard::isReady)
                    .build();

    private EndpointDescriptors() {
    }
}
