package ru.yandex.stockpile.client.impl;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.stockpile.api.TServerStatusResponse;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class NodeRefreshStatusRequest {
    private final NodeClient nodeClient;
    private final TServerStatusResponse response;
    private final CompletableFuture<Void> future;

    public NodeRefreshStatusRequest(NodeClient nodeClient, TServerStatusResponse response) {
        this.nodeClient = nodeClient;
        this.response = response;
        this.future = new CompletableFuture<>();
    }

    NodeClient getNodeClient() {
        return nodeClient;
    }

    TServerStatusResponse getResponse() {
        return response;
    }

    public CompletableFuture<Void> getFuture() {
        return future;
    }

    @Override
    public String toString() {
        return "NodeRefreshStatusRequest{" +
                "nodeClient=" + nodeClient +
                ", response=" + response +
                '}';
    }
}
