package ru.yandex.stockpile.client.impl;

import com.google.common.base.MoreObjects;

import ru.yandex.stockpile.api.EStockpileStatusCode;

/**
 * @author Vladimir Gordiychuk
 */
public class RequestStatus {
    private final EStockpileStatusCode code;
    private final String details;

    public RequestStatus(EStockpileStatusCode code, String details) {
        this.code = code;
        this.details = details;
    }

    public EStockpileStatusCode getCode() {
        return code;
    }

    public String getDetails() {
        return details;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("code", code)
                .add("details", details)
                .toString();
    }
}
