package ru.yandex.stockpile.client.impl;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Descriptors;
import com.google.protobuf.MessageOrBuilder;

import ru.yandex.stockpile.api.EStockpileStatusCode;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
// TODO: slow reflexion need optimization
public final class ResponseProtoFieldAccessor {
    /**

     TODO: slow reflexion need optimization
     Benchmark                           Mode  Cnt          Score          Error  Units
     DeadlineGetBenchmark.byInstanceOf  thrpt    5  192759084.912 ±  3961577.440  ops/s
     DeadlineGetBenchmark.byNumber      thrpt    5   40664218.263 ±  1601208.461  ops/s
     DeadlineGetBenchmark.direct        thrpt    5  228737322.105 ± 30924715.380  ops/s

     */

    private static final int STATUS_CODE_TAG = 1;
    private static final int STATUS_MESSAGE_TAG = 16;

    private ResponseProtoFieldAccessor() {
    }

    public static <Response extends MessageOrBuilder> EStockpileStatusCode getStockpileStatusCode(Response response) {
        Descriptors.FieldDescriptor statusDescriptor = response.getDescriptorForType().findFieldByNumber(STATUS_CODE_TAG);

        if (statusDescriptor == null || !"Status".equals(statusDescriptor.getName())) {
            return EStockpileStatusCode.UNKNOWN;
        }

        Descriptors.EnumValueDescriptor status = (Descriptors.EnumValueDescriptor) response.getField(statusDescriptor);
        return EStockpileStatusCode.valueOf(status);
    }

    @Nullable
    public static <Response extends MessageOrBuilder> String getStatusMessage(Response response) {
        Descriptors.FieldDescriptor statusDescriptor = response.getDescriptorForType().findFieldByNumber(STATUS_MESSAGE_TAG);

        if (statusDescriptor == null || !"StatusMessage".equals(statusDescriptor.getName())) {
            return null;
        }

        return (String) response.getField(statusDescriptor);
    }
}
