package ru.yandex.stockpile.client.impl;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * @author Vladimir Gordiychuk
 */
@NotThreadSafe
@ParametersAreNonnullByDefault
class Shard {
    private final String fqdn;
    private final int shardId;
    private final boolean ready;
    private final boolean readyWrite;
    private final boolean readyRead;
    private final long createdAt;

    Shard(String fqdn, int shardId, boolean ready, boolean readyWrite, boolean readyRead, long createdAt) {
        this.fqdn = fqdn;
        this.shardId = shardId;
        this.ready = ready;
        this.readyWrite = readyWrite;
        this.readyRead = readyRead;
        this.createdAt = createdAt;
    }

    int getShardId() {
        return shardId;
    }

    boolean isReady() {
        return ready;
    }

    boolean isReadyWrite() {
        return readyWrite;
    }

    boolean isReadyRead() {
        return readyRead;
    }

    String getFqdn() {
        return fqdn;
    }

    public long getCreatedAt() {
        return createdAt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Shard shard = (Shard) o;

        if (shardId != shard.shardId) return false;
        return fqdn.equals(shard.fqdn);
    }

    @Override
    public int hashCode() {
        int result = shardId;
        result = 31 * result + fqdn.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "Shard{" +
                "fqdn=" + fqdn +
                ", shardId=" + shardId +
                ", ready=" + ready +
                '}';
    }
}
