package ru.yandex.stockpile.client.impl;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.stockpile.api.EStockpileStatusCode;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
class StockpileRuntimeException extends RuntimeException {
    private final EStockpileStatusCode code;

    public StockpileRuntimeException(EStockpileStatusCode code, String message) {
        super(message, null, true, false);
        this.code = code;
    }

    public EStockpileStatusCode getCode() {
        return code;
    }
}
