package ru.yandex.stockpile.client.writeRequest;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public enum WriteRequestEventType {
    UNDEFINED(0),
    EVENT_POINT(1),
    EVENT_DELETE_DATA(2),
    EVENT_DELETE_DATA_WITH_TS(3),
    ;

    WriteRequestEventType(int v) {
        if (v != ordinal()) {
            throw new AssertionError();
        }
    }

    private static final WriteRequestEventType[] values = values();

    @Nonnull
    public static WriteRequestEventType byNumber(int number) {
        return values[number];
    }
}
