package ru.yandex.stockpile.client.writeRequest;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.model.point.AggrPointData;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.stockpile.client.writeRequest.serializers.SerializerVersion;
import ru.yandex.stockpile.client.writeRequest.serializers.WriteRequestPointSerializer;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class WriteRequestOutputStream {

    private final StockpileSerializer serializer;
    private final WriteRequestPointSerializer pointSerializer;
    final SerializerVersion serializerVersion = SerializerVersion.FLAT_WITH_STATE;

    WriteRequestOutputStream(StockpileSerializer serializer) {
        this.serializer = serializer;
        pointSerializer = serializerVersion.serializerGen.get();
    }

    private void writeEventType(WriteRequestEventType eventType) {
        if (eventType.ordinal() > 255) {
            throw new IllegalArgumentException("event type ordinal is greater than 255");
        }
        serializer.writeByte(eventType.ordinal());
    }

    public void addRecord(long localId, int pointMask, AggrPointData point, int decimPolicyId, MetricType type) {
        writeEventType(WriteRequestEventType.EVENT_POINT);
        pointSerializer.writeValue(serializer, localId, decimPolicyId, type, pointMask, point);
    }

    public void addDeleteData(long localId) {
        writeEventType(WriteRequestEventType.EVENT_DELETE_DATA);
        pointSerializer.writeDeleteData(serializer, localId);
    }

    public void addDeleteDataWithTs(long localId, long tsMillis) {
        writeEventType(WriteRequestEventType.EVENT_DELETE_DATA_WITH_TS);
        pointSerializer.writeDeleteDataWithTs(serializer, localId, tsMillis);
    }
}
