package ru.yandex.stockpile.client.writeRequest.serializers;

import ru.yandex.commune.protobuf.WireFormat;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;

/**
 * @author Maksim Leonov (nohttp@)
 */
public class BoolVarintFieldSerializer implements ProtobufFieldSerializer {
    public final int tag;

    public BoolVarintFieldSerializer(int fieldNumber) {
        tag = WireFormat.makeTag(fieldNumber, com.google.protobuf.WireFormat.WIRETYPE_VARINT);
    }

    public void writeValue(StockpileSerializer serializer, boolean value) {
        FieldTagSerializer.writeFieldTag(serializer, tag);
        serializer.writeBoolean(value);
    }

    public boolean readValue(int fieldTag, StockpileDeserializer deserializer) {
        if (fieldTag != tag) {
            throw new RuntimeException(fieldTag + " != " + tag);
        }
        return deserializer.readBoolean();
    }

    @Override
    public int tag() {
        return tag;
    }
}
