package ru.yandex.stockpile.client.writeRequest.serializers;

import ru.yandex.commune.protobuf.WireFormat;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.model.type.Histogram;

/**
 * @author Vladimir Gordiychuk
 */
public class DHistogramFieldSerializer implements ProtobufFieldSerializer {
    private final int tag;

    public DHistogramFieldSerializer(int fieldNumber) {
        tag = WireFormat.makeTag(fieldNumber, com.google.protobuf.WireFormat.WIRETYPE_VARINT);
    }

    @Override
    public int tag() {
        return tag;
    }

    public void writeValue(StockpileSerializer serializer, Histogram histogram) {
        FieldTagSerializer.writeFieldTag(serializer, tag);
        serializer.writeVarint64(histogram.getDenom());
        serializer.writeVarint32(histogram.count());
        for (int index = 0; index < histogram.count(); index++) {
            serializer.writeDouble(histogram.upperBound(index));
        }

        for (int index = 0; index < histogram.count(); index++) {
            serializer.writeVarint64(histogram.value(index));
        }
    }

    public Histogram readValue(int fieldTag, StockpileDeserializer deserializer) {
        if (fieldTag != tag) {
            throw new IllegalStateException(fieldTag + " != " + tag);
        }

        long denom = deserializer.readVarint64();
        int count = deserializer.readVarint32();
        Histogram hist = Histogram.newInstance();
        hist.setDenom(denom);
        for (int index = 0; index < count; index++) {
            hist.setUpperBound(index, deserializer.readDouble());
        }

        for (int index = 0; index < count; index++) {
            hist.setBucketValue(index, deserializer.readVarint64());
        }

        return hist;
    }
}
