package ru.yandex.stockpile.client.writeRequest.serializers;

import ru.yandex.commune.protobuf.WireFormat;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;

/**
 * @author Maksim Leonov (nohttp@)
 */
public class DoubleFixedFieldSerializer implements ProtobufFieldSerializer {
    public final int tag;

    public DoubleFixedFieldSerializer(int fieldNumber) {
        tag = WireFormat.makeTag(fieldNumber, com.google.protobuf.WireFormat.WIRETYPE_FIXED64);
    }

    public void writeValue(StockpileSerializer serializer, double value) {
        FieldTagSerializer.writeFieldTag(serializer, tag);
        serializer.writeDouble(value);
    }

    public double readValue(int fieldTag, StockpileDeserializer deserializer) {
        if (fieldTag != tag) {
            throw new RuntimeException(fieldTag + " != " + tag);
        }
        return deserializer.readDouble();
    }

    @Override
    public int tag() {
        return tag;
    }
}
