package ru.yandex.stockpile.client.writeRequest.serializers;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.commune.protobuf.WireFormat;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.model.type.Histogram;

/**
 * @author Vladimir Gordiychuk
 * @deprecated
 */
@ParametersAreNonnullByDefault
public class HistogramFieldSerializer implements ProtobufFieldSerializer {
    private final int tag;

    public HistogramFieldSerializer(int fieldNumber) {
        tag = WireFormat.makeTag(fieldNumber, com.google.protobuf.WireFormat.WIRETYPE_VARINT);
    }

    private static long toLongExact(double value) {
        if ((long) value != value) {
            throw new ArithmeticException("long overflow: " + value);
        }
        return (long) value;
    }

    @Override
    public int tag() {
        return tag;
    }

    public void writeValue(StockpileSerializer serializer, Histogram histogram) {
        FieldTagSerializer.writeFieldTag(serializer, tag);
        serializer.writeVarint32(histogram.count());
        for (int index = 0; index < histogram.count(); index++) {
            long bound = toLongExact(histogram.upperBound(index));
            serializer.writeVarint64(bound);
        }

        for (int index = 0; index < histogram.count(); index++) {
            serializer.writeVarint64(histogram.value(index));
        }
    }

    public Histogram readValue(int fieldTag, StockpileDeserializer deserializer) {
        if (fieldTag != tag) {
            throw new IllegalStateException(fieldTag + " != " + tag);
        }

        int count = deserializer.readVarint32();
        double[] bounds = new double[count];
        for (int index = 0; index < count; index++) {
            long value = deserializer.readVarint64();
            bounds[index] = value;
        }

        long[] buckets = new long[count];
        for (int index = 0; index < count; index++) {
            buckets[index] = deserializer.readVarint64();
        }

        return Histogram.newInstance(bounds, buckets);
    }
}
