package ru.yandex.stockpile.client.writeRequest.serializers;

import ru.yandex.commune.protobuf.WireFormat;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;

/**
 * @author Maksim Leonov (nohttp@)
 */
public class IntVarintFieldSerializer implements ProtobufFieldSerializer {
    public final int tag;

    public IntVarintFieldSerializer(int fieldNumber) {
        tag = WireFormat.makeTag(fieldNumber, com.google.protobuf.WireFormat.WIRETYPE_VARINT);
    }

    public void writeValue(StockpileSerializer serializer, int value) {
        FieldTagSerializer.writeFieldTag(serializer, tag);
        serializer.writeVarint32(value);
    }

    public int readValue(int fieldTag, StockpileDeserializer deserializer) {
        if (fieldTag != tag) {
            throw new RuntimeException(fieldTag + " != " + tag);
        }
        return deserializer.readVarint32();
    }

    @Override
    public int tag() {
        return tag;
    }
}
