package ru.yandex.stockpile.client.writeRequest.serializers;

import ru.yandex.commune.protobuf.WireFormat;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;

/**
 * @author Maksim Leonov (nohttp@)
 */
public class LongFixedFieldSerializer implements ProtobufFieldSerializer {
    public final int tag;

    public LongFixedFieldSerializer(int fieldNumber) {
        tag = WireFormat.makeTag(fieldNumber, com.google.protobuf.WireFormat.WIRETYPE_FIXED64);
    }

    public void writeValue(StockpileSerializer serializer, long value) {
        FieldTagSerializer.writeFieldTag(serializer, tag);
        serializer.writeFixed64(value);
    }

    public long readValue(int fieldTag, StockpileDeserializer deserializer) {
        if (fieldTag != tag) {
            throw new RuntimeException(fieldTag + " != " + tag);
        }
        return deserializer.readFixed64();
    }

    @Override
    public int tag() {
        return tag;
    }
}
