package ru.yandex.stockpile.client.writeRequest.serializers;

import ru.yandex.commune.protobuf.WireFormat;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;

/**
 * @author Maksim Leonov (nohttp@)
 */
public class LongVarintFieldSerializer implements ProtobufFieldSerializer {
    public final int tag;

    public LongVarintFieldSerializer(int fieldNumber) {
        tag = WireFormat.makeTag(fieldNumber, com.google.protobuf.WireFormat.WIRETYPE_VARINT);
    }

    public void writeValue(StockpileSerializer serializer, long value) {
        FieldTagSerializer.writeFieldTag(serializer, tag);
        serializer.writeVarint64(value);
    }

    public long readValue(int fieldTag, StockpileDeserializer deserializer) {
        if (fieldTag != tag) {
            throw new RuntimeException(fieldTag + " != " + tag);
        }
        return deserializer.readVarint64();
    }

    @Override
    public int tag() {
        return tag;
    }
}
