package ru.yandex.stockpile.client.writeRequest.serializers;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;

import ru.yandex.commune.protobuf.WireFormat;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;

/**
 * @author Maksim Leonov (nohttp@)
 */
public class LongZigzagFieldSerializer implements ProtobufFieldSerializer {
    public final int tag;

    public LongZigzagFieldSerializer(int fieldNumber) {
        tag = WireFormat.makeTag(fieldNumber, com.google.protobuf.WireFormat.WIRETYPE_VARINT);
    }

    public void writeValue(StockpileSerializer serializer, long value) {
        long encoded = CodedOutputStream.encodeZigZag64(value);
        FieldTagSerializer.writeFieldTag(serializer, tag);
        serializer.writeVarint64(encoded);
    }

    public long readValue(int fieldTag, StockpileDeserializer deserializer) {
        if (fieldTag != tag) {
            throw new RuntimeException(fieldTag + " != " + tag);
        }
        long zigzag = deserializer.readVarint64();
        return CodedInputStream.decodeZigZag64(zigzag);
    }

    @Override
    public int tag() {
        return tag;
    }
}
