package ru.yandex.stockpile.client.writeRequest.serializers;

import java.util.function.Supplier;

import ru.yandex.stockpile.client.writeRequest.serializers.flat.WriteRequestPointFlatDeserializer;
import ru.yandex.stockpile.client.writeRequest.serializers.flat.WriteRequestPointFlatSerializer;

public enum SerializerVersion {
    UNKNOWN(() -> { throw new RuntimeException(); }, () -> { throw new RuntimeException(); }),
    STRUCTURED(() -> { throw new RuntimeException(); }, () -> { throw new RuntimeException(); }),
    FLAT_WITH_STATE(WriteRequestPointFlatSerializer::new, WriteRequestPointFlatDeserializer::new),;

    public final Supplier<WriteRequestPointSerializer> serializerGen;
    public final Supplier<WriteRequestPointDeserializer> deserializerGen;

    SerializerVersion(Supplier<WriteRequestPointSerializer> serializerGen, Supplier<WriteRequestPointDeserializer> deserializerGen) {
        this.serializerGen = serializerGen;
        this.deserializerGen = deserializerGen;
    }

    private static final SerializerVersion[] VALUES = values();

    public static SerializerVersion byIdOrUnknown(int id) {
        if (id >= 0 && id < VALUES.length) {
            return VALUES[id];
        }
        return UNKNOWN;
    }
}
