package ru.yandex.stockpile.client.writeRequest.serializers;

import ru.yandex.commune.protobuf.WireFormat;
import ru.yandex.monlib.metrics.summary.ImmutableSummaryDoubleSnapshot;
import ru.yandex.monlib.metrics.summary.SummaryDoubleSnapshot;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;

/**
 * @author Vladimir Gordiychuk
 */
public class SummaryDoubleFieldSerializer implements ProtobufFieldSerializer {
    private final int tag;

    public SummaryDoubleFieldSerializer(int fieldNumber) {
        tag = WireFormat.makeTag(fieldNumber, com.google.protobuf.WireFormat.WIRETYPE_VARINT);
    }

    @Override
    public int tag() {
        return tag;
    }

    public void writeValue(StockpileSerializer serializer, SummaryDoubleSnapshot summary) {
        FieldTagSerializer.writeFieldTag(serializer, tag);
        serializer.writeVarint64(summary.getCount());
        serializer.writeDouble(summary.getSum());
        serializer.writeDouble(summary.getMin());
        serializer.writeDouble(summary.getMax());
    }

    public SummaryDoubleSnapshot readValue(int fieldTag, StockpileDeserializer deserializer) {
        if (fieldTag != tag) {
            throw new IllegalStateException(fieldTag + " != " + tag);
        }

        long count = deserializer.readVarint64();
        double sum = deserializer.readDouble();
        double min = deserializer.readDouble();
        double max = deserializer.readDouble();

        return new ImmutableSummaryDoubleSnapshot(count, sum, min, max);
    }
}
