package ru.yandex.stockpile.client.writeRequest.serializers;

import ru.yandex.commune.protobuf.WireFormat;
import ru.yandex.monlib.metrics.summary.ImmutableSummaryInt64Snapshot;
import ru.yandex.monlib.metrics.summary.SummaryInt64Snapshot;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;

/**
 * @author Vladimir Gordiychuk
 */
public class SummaryInt64FieldSerializer implements ProtobufFieldSerializer {
    private final int tag;

    public SummaryInt64FieldSerializer(int fieldNumber) {
        tag = WireFormat.makeTag(fieldNumber, com.google.protobuf.WireFormat.WIRETYPE_VARINT);
    }

    @Override
    public int tag() {
        return tag;
    }

    public void writeValue(StockpileSerializer serializer, SummaryInt64Snapshot summary) {
        FieldTagSerializer.writeFieldTag(serializer, tag);
        serializer.writeVarint64(summary.getCount());
        serializer.writeVarint64(summary.getSum());
        serializer.writeVarint64(summary.getMin());
        serializer.writeVarint64(summary.getMax());
    }

    public SummaryInt64Snapshot readValue(int fieldTag, StockpileDeserializer deserializer) {
        if (fieldTag != tag) {
            throw new IllegalStateException(fieldTag + " != " + tag);
        }

        long count = deserializer.readVarint64();
        long sum = deserializer.readVarint64();
        long min = deserializer.readVarint64();
        long max = deserializer.readVarint64();

        return new ImmutableSummaryInt64Snapshot(count, sum, min, max);
    }
}
