package ru.yandex.stockpile.client.writeRequest.serializers;

import javax.annotation.ParametersAreNonnullByDefault;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;

import ru.yandex.solomon.codec.archive.MetricArchiveMutable;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.stockpile.api.EProjectId;

/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
public interface WriteRequestPointDeserializer {
    void readValueTo(
        Long2ObjectMap<MetricArchiveMutable> target,
        StockpileDeserializer deserializer,
        EProjectId projectId, int stockpileOwnerShardId);

    void readDeleteDataTo(
        Long2ObjectMap<MetricArchiveMutable> target,
        StockpileDeserializer deserializer);

    void readDeleteDataWithTsTo(
        Long2ObjectMap<MetricArchiveMutable> target,
        StockpileDeserializer deserializer);
}
