package ru.yandex.stockpile.client.writeRequest.serializers;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.model.point.AggrPointData;
import ru.yandex.solomon.model.protobuf.MetricType;

/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
public interface WriteRequestPointSerializer {
    // TODO: serializer must not be a method parameter, because class is stateful
    void writeValue(
        StockpileSerializer serializer,
        long localId,
        int decimPolicyId,
        MetricType type,
        int pointMask,
        AggrPointData point);

    void writeDeleteData(
        StockpileSerializer serializer,
        long localId);

    void writeDeleteDataWithTs(
        StockpileSerializer serializer,
        long localId,
        long tsMillis);
}
