package ru.yandex.stockpile.client.writeRequest.serializers.flat;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.model.point.column.CountColumn;

/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
class FlatCountEncoder {
    static int encodePointCount(StockpileSerializer serializer, FlatEncoderState state, int count) {
        CountColumn.validateOrThrow(count);

        int sameFieldMaskChange = 0;
        if (state.lastCount == count) {
            sameFieldMaskChange = CountColumn.mask;
        } else {
            AllFields.COUNT_ABSOLUTE_ENCODER.writeValue(serializer, count);
        }
        state.lastCount = count;
        return sameFieldMaskChange;
    }

    static boolean tryDecodePointCountValue(int fieldTag, StockpileDeserializer deserializer, FlatEncoderState state) {
        if (fieldTag == AllFields.COUNT_ABSOLUTE_ENCODER.tag) {
            state.lastCount = AllFields.COUNT_ABSOLUTE_ENCODER.readValue(fieldTag, deserializer);
            return true;
        } else {
            return false;
        }
    }
}
