package ru.yandex.stockpile.client.writeRequest.serializers.flat;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;

/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
class FlatDecimPolicyIdEncoder {
    static void encodeDecimPolicyId(StockpileSerializer serializer, FlatEncoderState state, int decimPolicyId) {
        if (state.lastDecimPolicyId != decimPolicyId) {
            AllFields.POLICY_ID_ENCODER.writeValue(serializer, decimPolicyId);
        }
        state.lastDecimPolicyId = decimPolicyId;
    }

    static boolean tryDecodeDecimPolicyId(int fieldTag, StockpileDeserializer deserializer, FlatEncoderState state) {
        if (fieldTag == AllFields.POLICY_ID_ENCODER.tag) {
            state.lastDecimPolicyId = AllFields.POLICY_ID_ENCODER.readValue(fieldTag, deserializer);
            return true;
        } else {
            return false;
        }
    }
}
