package ru.yandex.stockpile.client.writeRequest.serializers.flat;

import java.lang.invoke.MethodHandle;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.commune.mh.builder.MhBuilder;
import ru.yandex.monlib.metrics.summary.SummaryDoubleSnapshot;
import ru.yandex.monlib.metrics.summary.SummaryInt64Snapshot;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.AggrPointData;
import ru.yandex.solomon.model.point.column.HistogramColumn;
import ru.yandex.solomon.model.point.column.LongValueColumn;
import ru.yandex.solomon.model.point.column.StockpileColumnField;
import ru.yandex.solomon.model.point.column.StockpileColumnFieldMh;
import ru.yandex.solomon.model.point.column.StockpileColumnSet;
import ru.yandex.solomon.model.point.column.StockpileColumnSetMh;
import ru.yandex.solomon.model.point.column.SummaryDoubleColumn;
import ru.yandex.solomon.model.point.column.SummaryInt64Column;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.type.Histogram;
import ru.yandex.solomon.model.type.LogHistogram;
import ru.yandex.stockpile.api.EDecimPolicy;
import ru.yandex.stockpile.client.shard.StockpileLocalId;

@ParametersAreNonnullByDefault
class FlatEncoderState {
    long lastStockpileLocalId = StockpileLocalId.MIN;
    // TODO: should be UNDEFINED
    int lastDecimPolicyId = EDecimPolicy.POLICY_KEEP_FOREVER.getNumber();
    MetricType lastType = MetricType.METRIC_TYPE_UNSPECIFIED;

    @StockpileColumnField.A(StockpileColumnField.TS)
    long lastTsMillis = 0;
    @StockpileColumnField.A(StockpileColumnField.VALUE_NUM)
    double lastValueNum = 0;
    @StockpileColumnField.A(StockpileColumnField.VALUE_DENOM)
    long lastValueDenom = 0;
    @StockpileColumnField.A(StockpileColumnField.STEP)
    long lastStepMillis = 0;
    @StockpileColumnField.A(StockpileColumnField.MERGE)
    boolean lastMerge = false;
    @StockpileColumnField.A(StockpileColumnField.COUNT)
    long lastCount = 0;
    @StockpileColumnField.A(StockpileColumnField.LOG_HISTOGRAM)
    LogHistogram logHistogram = null;
    @StockpileColumnField.A(StockpileColumnField.HISTOGRAM)
    Histogram histogram = HistogramColumn.DEFAULT_VALUE;
    @StockpileColumnField.A(StockpileColumnField.ISUMMARY)
    SummaryInt64Snapshot summaryInt64 = SummaryInt64Column.DEFAULT_VALUE;
    @StockpileColumnField.A(StockpileColumnField.DSUMMARY)
    SummaryDoubleSnapshot summaryDouble = SummaryDoubleColumn.DEFAULT_VALUE;
    @StockpileColumnField.A(StockpileColumnField.LONG_VALUE)
    long lastLongValue = LongValueColumn.DEFAULT_VALUE;

    private static final MethodHandle copyToPointData =
        MhBuilder.oneshot3(
            FlatEncoderState.class, AggrPointData.class, StockpileColumnSetMh.primitiveParamType,
            StockpileColumnFieldMh::copyFieldsFilterByMask);

    @Nonnull
    public AggrPoint toAggrPoint(int columnSetMask) {
        AggrPoint r = new AggrPoint();
        r.columnSet = columnSetMask;
        try {
            copyToPointData.invokeExact(this, (AggrPointData) r, columnSetMask);
        } catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return r;
    }

    public void copyTo(int columnSetMask, AggrPoint point) {
        int clearMask = StockpileColumnSet.maxMask & ~columnSetMask;
        point.clearFields(clearMask);
        point.columnSet = columnSetMask;
        try {
            copyToPointData.invokeExact(this, (AggrPointData) point, columnSetMask);
        } catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}
