package ru.yandex.stockpile.client.writeRequest.serializers.flat;

import java.util.Objects;

import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.model.point.column.StockpileColumn;
import ru.yandex.solomon.model.type.Histogram;

/**
 * @author Vladimir Gordiychuk
 */
public class FlatHistogramEncoder {

    static int encodeHistogram(StockpileSerializer serializer, FlatEncoderState state, Histogram histogram) {
        if (Objects.equals(state.histogram, histogram)) {
            return StockpileColumn.HISTOGRAM.mask();
        }
        AllFields.DHISTOGRAM_ENCODER.writeValue(serializer, histogram);
        state.histogram = histogram;
        return 0;
    }

    static boolean tryDecodeHistogram(int fieldTag, StockpileDeserializer deserializer, FlatEncoderState state) {
        if (fieldTag == AllFields.DHISTOGRAM_ENCODER.tag()) {
            state.histogram = AllFields.DHISTOGRAM_ENCODER.readValue(fieldTag, deserializer);
            return true;
        }

        return false;
    }
}
