package ru.yandex.stockpile.client.writeRequest.serializers.flat;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.stockpile.client.shard.StockpileLocalId;

/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
class FlatLocalIdEncoder {
    static void encodeLocalId(StockpileSerializer serializer, FlatEncoderState state, long stockpileLocalId) {
        StockpileLocalId.validate(stockpileLocalId);

        if (state.lastStockpileLocalId != stockpileLocalId) {
            AllFields.LOCAL_ID_ENCODER.writeValue(serializer, stockpileLocalId);
        }
        state.lastStockpileLocalId = stockpileLocalId;
    }

    static boolean tryDecodeLocalId(int fieldTag, StockpileDeserializer deserializer, FlatEncoderState state) {
        if (fieldTag == AllFields.LOCAL_ID_ENCODER.tag) {
            state.lastStockpileLocalId = AllFields.LOCAL_ID_ENCODER.readValue(fieldTag, deserializer);
            return true;
        } else {
            return false;
        }
    }
}
