package ru.yandex.stockpile.client.writeRequest.serializers.flat;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.model.type.LogHistogram;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
class FlatLogHistogramEncoder {
    static int encodeLogHistogram(StockpileSerializer serializer, FlatEncoderState state, LogHistogram logHistogram) {
        AllFields.LOG_HISTOGRAM_ENCODER.writeValue(serializer, logHistogram);
        state.logHistogram = logHistogram;
        return 0;
    }

    static boolean tryDecodeLogHistogram(int fieldTag, StockpileDeserializer deserializer, FlatEncoderState state) {
        if (fieldTag != AllFields.LOG_HISTOGRAM_ENCODER.tag()) {
            return false;
        }
        state.logHistogram = AllFields.LOG_HISTOGRAM_ENCODER.readValue(fieldTag, deserializer);
        return true;
    }
}
