package ru.yandex.stockpile.client.writeRequest.serializers.flat;

import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.model.point.column.LongValueColumn;
import ru.yandex.solomon.model.point.column.StockpileColumn;

/**
 * @author Vladimir Gordiychuk
 */
public class FlatLongValueEncoder {
    static int encodePointValue(StockpileSerializer serializer, FlatEncoderState state, long value) {
        LongValueColumn.validateOrThrow(value);

        if (state.lastLongValue == value) {
            return StockpileColumn.LONG_VALUE.mask();
        }

        AllFields.LONG_VALUE_ENCODER.writeValue(serializer, value);
        state.lastLongValue = value;
        return 0;
    }

    static boolean tryDecodePointValue(int fieldTag, StockpileDeserializer deserializer, FlatEncoderState state) {
        if (fieldTag != AllFields.LONG_VALUE_ENCODER.tag) {
            return false;
        }

        state.lastLongValue = AllFields.LONG_VALUE_ENCODER.readValue(fieldTag, deserializer);
        return true;
    }
}
