package ru.yandex.stockpile.client.writeRequest.serializers.flat;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.model.point.column.MergeColumn;

/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
class FlatMergeEncoder {
    static int encodePointMerge(StockpileSerializer serializer, FlatEncoderState state, boolean merge) {
        MergeColumn.validateOrThrow(merge);

        int sameFieldMaskChange = 0;
        if (state.lastMerge == merge) {
            sameFieldMaskChange = MergeColumn.mask;
        } else {
            AllFields.MERGE_ENCODER.writeValue(serializer, merge);
        }
        state.lastMerge = merge;
        return sameFieldMaskChange;
    }

    static boolean tryDecodePointMerge(int fieldTag, StockpileDeserializer deserializer, FlatEncoderState state) {
        if (fieldTag == AllFields.MERGE_ENCODER.tag) {
            state.lastMerge = AllFields.MERGE_ENCODER.readValue(fieldTag, deserializer);
            return true;
        } else {
            return false;
        }
    }
}
